/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class Canvas6
extends JPanel {
    protected static final double DEG = Math.PI / 180;
    protected static final double PI2 = Math.PI * 2;
    protected static final BasicStroke THIN = new BasicStroke(1.0f);
    protected static final BasicStroke THICK = new BasicStroke(3.0f, 1, 1);
    private static Line2D LINE = new Line2D.Double();
    private static GeneralPath POLYGON = new GeneralPath();
    private static Rectangle2D RECTANGLE = new Rectangle2D.Double();
    private static Ellipse2D ELLIPSE = new Ellipse2D.Double();
    private static Arc2D ARC = new Arc2D.Double();
    protected AP6 frame;
    protected Font fH;

    public Canvas6(AP6 p, Color c) {
        this.frame = p;
        this.setBackground(c);
        this.fH = new Font("Sansserif", 1, 12);
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    protected void setAntiAliasing(Graphics2D g, boolean aa) {
        if (aa) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    protected void alignText(Graphics2D g, String s, Font f, int typ, int x, int y) {
        FontMetrics fm = this.getFontMetrics(f);
        int w = fm.stringWidth(s);
        this.setAntiAliasing(g, false);
        g.drawString(s, x - typ * w / 2, y);
        this.setAntiAliasing(g, true);
    }

    private static void setStroke(Graphics2D g, double d) {
        if (d == 1.0) {
            g.setStroke(THIN);
        } else if (d == 3.0) {
            g.setStroke(THICK);
        } else {
            g.setStroke(new BasicStroke((float)d));
        }
    }

    protected static void line(Graphics2D g, double d, double x1, double y1, double x2, double y2) {
        Canvas6.setStroke(g, d);
        LINE.setLine(x1, y1, x2, y2);
        g.draw(LINE);
    }

    protected static void line(Graphics2D g, double x1, double y1, double x2, double y2) {
        Canvas6.line(g, 1.0, x1, y1, x2, y2);
    }

    protected static void arrow(Graphics2D g, double d, double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double length = Math.sqrt(dx * dx + dy * dy);
        if (length == 0.0) {
            return;
        }
        Canvas6.setStroke(g, d);
        double s = 2.5 * d + 7.5;
        double xSp = x2 - s * (dx /= length);
        double ySp = y2 - s * (dy /= length);
        if (length < 5.0) {
            return;
        }
        double h = 0.5 * d + 3.5;
        double xSp1 = xSp - h * dy;
        double ySp1 = ySp + h * dx;
        double xSp2 = xSp + h * dy;
        double ySp2 = ySp - h * dx;
        xSp = x2 - 0.6 * s * dx;
        ySp = y2 - 0.6 * s * dy;
        Canvas6.line(g, d, x1, y1, xSp, ySp);
        POLYGON.reset();
        POLYGON.moveTo((float)xSp1, (float)ySp1);
        POLYGON.lineTo((float)x2, (float)y2);
        POLYGON.lineTo((float)xSp2, (float)ySp2);
        POLYGON.lineTo((float)xSp, (float)ySp);
        POLYGON.lineTo((float)xSp1, (float)ySp1);
        g.fill(POLYGON);
    }

    protected static void arrow(Graphics2D g, double x1, double y1, double x2, double y2) {
        Canvas6.arrow(g, 1.0, x1, y1, x2, y2);
    }

    protected void polygon(Graphics2D g, double d, double[] x, double[] y, Color c, boolean f) {
        Canvas6.setStroke(g, d);
        POLYGON.reset();
        POLYGON.moveTo((float)x[0], (float)y[0]);
        int dimX = x.length;
        int dimY = y.length;
        int dim = Math.min(dimX, dimY);
        for (int i = 1; i < dim; ++i) {
            POLYGON.lineTo((float)x[i], (float)y[i]);
        }
        POLYGON.lineTo((float)x[0], (float)y[0]);
        g.setColor(c);
        if (f) {
            g.fill(POLYGON);
            g.setColor(Color.black);
        }
        g.draw(POLYGON);
    }

    protected void polygon(Graphics2D g, double[] x, double[] y, Color c, boolean f) {
        this.polygon(g, 1.0, x, y, c, f);
    }

    protected void rectangle(Graphics2D g, double d, double x, double y, double w, double h, Color c, boolean f) {
        Canvas6.setStroke(g, d);
        RECTANGLE.setRect(x, y, w, h);
        g.setColor(c);
        if (f) {
            g.fill(RECTANGLE);
            g.setColor(Color.black);
        }
        g.draw(RECTANGLE);
    }

    protected void rectangle(Graphics2D g, double x, double y, double w, double h, Color c, boolean f) {
        this.rectangle(g, 1.0, x, y, w, h, c, f);
    }

    protected static void circle(Graphics2D g, double d, double x, double y, double r, Color c, boolean f) {
        Canvas6.setStroke(g, d);
        ELLIPSE.setFrame(x - r, y - r, 2.0 * r, 2.0 * r);
        g.setColor(c);
        if (f) {
            g.fill(ELLIPSE);
            g.setColor(Color.black);
        }
        g.draw(ELLIPSE);
    }

    protected static void circle(Graphics2D g, double x, double y, double r, Color c, boolean f) {
        Canvas6.circle(g, 1.0, x, y, r, c, f);
    }

    protected static void circle(Graphics2D g, double x, double y, double r, Color c) {
        ELLIPSE.setFrame(x - r, y - r, 2.0 * r, 2.0 * r);
        g.setColor(c);
        g.fill(ELLIPSE);
    }

    protected static void arc(Graphics2D g, double d, double x, double y, double r, double w0, double dw) {
        Canvas6.setStroke(g, d);
        ARC.setFrame(x - r, y - r, 2.0 * r, 2.0 * r);
        ARC.setAngleStart(w0 / (Math.PI / 180));
        ARC.setAngleExtent(dw / (Math.PI / 180));
        g.draw(ARC);
    }

    protected static void arc(Graphics2D g, double x, double y, double r, double w0, double dw) {
        Canvas6.arc(g, 1.0, x, y, r, w0, dw);
    }

    protected static void angle(Graphics2D g, double x, double y, double r, double w0, double dw, Color c) {
        if (w0 < 0.0) {
            w0 += Math.PI * 2;
        }
        if (w0 > Math.PI * 2) {
            w0 -= Math.PI * 2;
        }
        if (dw < 0.0) {
            dw += Math.PI * 2;
        }
        if (dw > Math.PI * 2) {
            dw -= Math.PI * 2;
        }
        ARC.setArc(x - r, y - r, 2.0 * r, 2.0 * r, w0 / (Math.PI / 180), dw / (Math.PI / 180), 2);
        g.setColor(c);
        g.fill(ARC);
        g.setColor(Color.black);
        g.draw(ARC);
    }
}

